<?php
/**
 * Better Category Selector for WooCommerce Category Selector
 */

defined('ABSPATH') or die('No script kiddies please!');

/**
 * Better WooCommerce Category Selector
 */

/**
 * Display callback for the submenu page.

  if ( ! isset( $_GET['inline'] ) ) {
  	define( 'IFRAME_REQUEST', true );
  }
 */

// IDs should be integers.
$bcs_post_id = isset( $_REQUEST['post_id'] ) ? (int) sanitize_text_field($_REQUEST['post_id']) : 0;

if ( ! empty( $bcs_post_id ) && ! current_user_can( 'edit_post', $bcs_post_id ) ) {
	wp_die(
		'<h1>' . __( 'You need a higher level of permission.' ) . '</h1>' .
		'<p>' . __( 'Sorry, you are not allowed to edit this item.' ) . '</p>',
		403
	);
}

hd_bcs_show_bcs_category_selector($bcs_post_id);
function hd_bcs_show_bcs_category_selector($post_id ){

  $post = get_post($post_id);
  $tax_name    = esc_attr( 'product_cat' );
  $taxonomy    = get_taxonomy( 'product_cat' );

?>

<div class="bcs-frame-title" id="bcs-frame-title">
  <h1>Better Category Selector for WooCommerce</h1>
</div>

<?php
if(!HD_BCS_PLUGIN_VERSION_PRO){
?>
<div id="bcs-upgrade-ad">
<h2><a href="https://www.hisdesigns.org/live/2022/02/04/better-category-selector-for-woocommerce-pro/" target="_blank"><img src="<?php echo esc_url(HD_BCS_PLUGIN_URL) ?>/images/nobrainer_logo_220209.png" class="nobrainer_logo"></a>Do you like this category selector?</h2>
<h2>Would you like to be able to expand parent categories to select child categories?</h2>
<p><a href="https://www.hisdesigns.org/live/2022/02/04/better-category-selector-for-woocommerce-pro/" target="_blank" class="button button-primary button-large">Click here to upgrade now!</a></p>
</div>
<?php
}
?>

<div id="taxonomy-<?php echo esc_attr($tax_name); ?>" class="bcs_categorydiv categorydiv">
  <ul id="<?php echo esc_attr($tax_name); ?>-tabs" class="category-tabs">
    <li class="tabs"><a href="#<?php echo esc_attr($tax_name); ?>-all"><?php echo esc_html($taxonomy->labels->all_items); ?></a></li>
    <li class="hide-if-no-js"><a href="#<?php echo esc_attr($tax_name); ?>-pop"><?php echo esc_html( $taxonomy->labels->most_used ); ?></a></li>
    <?php /*** <!-- Pro option only - Not done yet.
  <?php if ( current_user_can( $taxonomy->cap->edit_terms ) ) : ?>
    <li class="hide-if-no-js"><a href="#<?php echo esc_attr($tax_name); ?>-edit">Add/Edit <?php echo esc_html( $taxonomy->labels->menu_name ); ?></a></li>
  <?php endif; ?>
     --> ***/ ?>
  </ul>

  <div id="<?php echo esc_attr($tax_name); ?>-pop" class="tabs-panel" style="display: none;">
    <ul id="<?php echo esc_attr($tax_name); ?>checklist-pop" class="categorychecklist form-no-clear" >
      <?php $popular_ids = hd_bcs_popular_terms_checklist( $tax_name, 0, 10, true, $post ); ?>
    </ul>
  </div>

  <div id="<?php echo esc_attr($tax_name); ?>-all" class="tabs-panel <?php echo(((HD_BCS_PLUGIN_VERSION_PRO)?"bcs-pro":"")) ?>">
    <?php
    $name = ( 'category' === $tax_name ) ? 'post_category' : 'tax_input[' . $tax_name . ']';
    // Allows for an empty term set to be sent. 0 is an invalid term ID and will be ignored by empty() checks.
    echo ("<input type='hidden' name='" . esc_attr($name) . "[]' value='0' />");
    ?>
    <ul id="<?php echo esc_attr($tax_name); ?>checklist" data-wp-lists="list:<?php echo esc_attr($tax_name); ?>" class="categorychecklist form-no-clear">
      <?php
      wp_terms_checklist(
        $post->ID,
        array(
          'taxonomy'     => $tax_name,
          'popular_cats' => $popular_ids,
          'walker'       => new HD_BCS_Walker_Category_Checklist,
        )
      );
      ?>
    </ul>
  </div>

  <div id="<?php echo esc_attr($tax_name); ?>-edit" class="tabs-panel" style="display: none;">
  Add/Edit Cats
  </div>

</div>
<p><button type="button" id="BCS_closeWindowButton" class="button button-primary button-large">Close and continue editing product</button> <button type="button" id="BCS_closeWindowSaveButton" class="button button-primary button-large">Close and save product</button></p>

<?php
}