<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );

// Fixes because woo sucks!
$catObj = get_term_by( 'name', woocommerce_page_title(false), 'product_cat' );
$thumbnail_url = "";
$display_type = "products";

if(is_object($catObj) && $catObj->term_id != ""){

  $display_type = get_term_meta($catObj->term_id,'display_type',true);
  $thumbnail_id = get_term_meta($catObj->term_id,'thumbnail_id',true);

  if($thumbnail_id != ""){
    $thumbnail_url = wp_get_attachment_image_src( $thumbnail_id , "full");
    $thumbnail_url = $thumbnail_url[0];
    //echo("|||| $thumbnail_url ||||<br>");
  }

}
//echo("|||| " .  print_r($GLOBALS['wp_query'],true) . " ||||<br>");
?>

<script type="text/javascript">
jQuery(document).ready(function($){

  thumbnail_url = "<?= $thumbnail_url ?>";
  if(thumbnail_url != "" && !$('#intro').length){
    $('<div id="intro"><div id="intro_inner"><div class="image_banner_intro"><img class="image_banner" src="' + thumbnail_url + '" title="<?php woocommerce_page_title() ?>" alt="<?php woocommerce_page_title() ?>" width="960" height="400"><h1 class="intro_title"><span><?php woocommerce_page_title() ?></span></h1></div></div><!-- #intro_inner --></div>').insertAfter('#primary_menu');
    $('body').addClass('has_image_banner');
  }

  if($('head title').text() == ""){
    $('head title').text('<?php woocommerce_page_title() ?>');
  }
  else if($('head title').text().indexOf('<?php woocommerce_page_title() ?>') == -1){
    $('head title').text($('head title').text() + ' | <?php woocommerce_page_title() ?>');
  }

  $('term-description').remove();

});
</script>



<header class="woocommerce-products-header">
	<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
		<h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
	<?php endif; ?>

	<?php
	/**
	 * Hook: woocommerce_archive_description.
	 *
	 * @hooked woocommerce_taxonomy_archive_description - 10
	 * @hooked woocommerce_product_archive_description - 10
	 */
	do_action( 'woocommerce_archive_description' );
	?>
</header>
<?php
if ( woocommerce_product_loop() && ($display_type == "subcategories")) {

	/**
	 * Hook: woocommerce_before_shop_loop.
	 *
	 * @hooked woocommerce_output_all_notices - 10
	 * @hooked woocommerce_result_count - 20
	 * @hooked woocommerce_catalog_ordering - 30
	 */
	do_action( 'woocommerce_before_shop_loop' );

	woocommerce_product_loop_start();

	if ( wc_get_loop_prop( 'total' ) ) {

		while ( have_posts() ) {
			the_post();

			/**
			 * Hook: woocommerce_shop_loop.
			 *
			 * @hooked WC_Structured_Data::generate_product_data() - 10
			 */
			do_action( 'woocommerce_shop_loop' );

			wc_get_template_part( 'content', 'product' );
		}
	}

	woocommerce_product_loop_end();

	/**
	 * Hook: woocommerce_after_shop_loop.
	 *
	 * @hooked woocommerce_pagination - 10
	 */
	do_action( 'woocommerce_after_shop_loop' );
}
else if($display_type == "products"){
		while ( have_posts() ) {
			the_post();
      global $post;
      echo($post->post_content);
    }
}
else {
	/**
	 * Hook: woocommerce_no_products_found.
	 *
	 * @hooked wc_no_products_found - 10
	 */
	do_action( 'woocommerce_no_products_found' );
}

/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
do_action( 'woocommerce_sidebar' );

?>
	<?php mysite_after_page_content(); ?>
	
		<div class="clearboth"></div>
	</div><!-- #main_inner -->
</div><!-- #main -->
<?php
get_footer( 'shop' );
