<?php
/*
 * Plugin Name: Easy Digital Downloads - Adding a custom field
 * Description: Adding a custom field to the checkout screen
 * Author: IDK
 * Version: 1.0
 */
 
/**
 * Adding a custom field to the checkout screen
 *
 * Covers:
 * 
 * Adding a comment number field to the checkout
 * Making the comment number field required
 * Setting an error when the comment number field is not filled out
 * Storing the comment number into the payment meta
 * Adding the customer's comment number to the "view order details" screen
 * Adding a new {comment} email tag so you can display the comment number in the email notifications (standard purchase receipt or admin notification)
 */
/**
 * Display comment number field at checkout
 * Add more here if you need to
 */
function sumobi_edd_display_checkout_fields() {
?>
    <p id="edd-comment-wrap">
        <label class="edd-label" for="edd-comment">
        	<?php echo 'Note to Seller (Optional)'; ?>
        </label>
        <span class="edd-description">
        	<?php echo 'Order details.'; ?>
        </span>
        <textarea class="edd-input" name="edd_comment" id="edd-comment" ></textarea>
    </p>
    <?php
}
add_action( 'edd_purchase_form_user_info', 'sumobi_edd_display_checkout_fields' );

/**
 * Store the custom field data into EDD's payment meta
 */
function sumobi_edd_store_custom_fields( $payment_meta ) {
    $payment_meta['comment'] = isset( $_POST['edd_comment'] ) ? sanitize_text_field( $_POST['edd_comment'] ) : '';
    
    return $payment_meta;
}
add_filter( 'edd_payment_meta', 'sumobi_edd_store_custom_fields');
/**
 * Add the comment to the "View Order Details" page
 */
function sumobi_edd_view_order_details( $payment_meta, $user_info ) {
	$comment = isset( $payment_meta['comment'] ) ? $payment_meta['comment'] : 'none';
?>
    <div class="column-container">
    	<div class="column">
    		<strong><?php echo 'Comment: '; ?></strong><br/>
    		 <textarea><?php echo $comment; ?>	</textarea>
    	</div>
    </div>
<?php
}
add_action( 'edd_payment_personal_details_list', 'sumobi_edd_view_order_details', 10, 2 );
/**
 * Add a {comment} tag for use in either the purchase receipt email or admin notification emails
 */
edd_add_email_tag( 'comment', 'Customer\'s comment', 'sumobi_edd_email_tag_comment' );
/**
 * The {comment} email tag
 */
function sumobi_edd_email_tag_comment( $payment_id ) {
	$payment_data = edd_get_payment_meta( $payment_id );
	return $payment_data['comment'];
}